<?php
header('Pragma: public');
header('Expires: 0');
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Cache-Control: private', false);

//Opensource fix for tracking email access count
chdir(dirname(__FILE__). '/../../');

require_once 'includes/Loader.php';
require_once 'include/utils/utils.php';

vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');

class Creantis_GetDataVtiger_Action extends Vtiger_Action_Controller {

	public function process(Vtiger_Request $request) {
		// if (vglobal('application_unique_key') !== $request->get('applicationKey')) {
		// 	exit;
		// }
		if((strpos($_SERVER['HTTP_REFERER'], vglobal('site_URL')) === false)) {
			exit;
		}
		if($_SERVER['REQUEST_METHOD'] != 'POST') {
			exit;
		}

		global $current_user;
		$current_user = Users::getActiveAdminUser();
		
		if($request->get('method') == 'getUsers') {
			$data = $this->getUsersHandler($request);
		}else{
			$data = array();
		}
		echo json_encode(array('data'=>$data));
		exit;
	}
	
	public function getUsersHandler(Vtiger_Request $request) {
		global $adb;
		// $adb->setDebug(true);
		$rs = $adb->pquery("SELECT user_name, TRIM(concat(first_name,' ',last_name)) as name FROM vtiger_users WHERE status = 'Active' AND deleted = '0'");
		$data = array();
		while ($row = $adb->fetch_row($rs)) {
			$row = array_map("decode_html", $row);
			$data[] = array("val" => $row["user_name"], "meta" => $row['name']);
		}
		return $data;
	}
}

$track = new Creantis_GetDataVtiger_Action();
$track->process(new Vtiger_Request($_REQUEST));
