<?php

chdir("../../");
require_once 'data/CRMEntity.php';
include_once 'includes/main/WebUI.php';
include_once 'vtlib/Vtiger/Module.php';
require_once 'includes/Loader.php';
require_once 'include/utils/utils.php';

vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');

ini_set('max_execution_time', 0);
set_time_limit(0);

global $current_user;
$current_user->id = 1;

/**
 * Script que se encarga de copiar un # de caso B2C y duplicarlo con otro # de caso para asignarlo a otro grupo.
 */
function main()
{
    global $adb;
    debug("[INFO]:: Buscando Oportunidades'");
    $caso = [ #Matriz: caso origen => grupo a asignar una vez duplicado
        1   =>  6,
        2   =>  7,
        3   =>  8
    ];

    $pModel = Vtiger_Record_Model::getCleanInstance('Potentials');
    foreach ($caso as $c_origen => $c_grupo) {
        
        
        $sq1 = $adb->pquery("SELECT u.id FROM vtiger_users u
                JOIN vtiger_user2role u2r ON u2r.userid=u.id 
                JOIN vtiger_role r ON r.roleid = u2r.roleid 
                WHERE u.deleted = 0 AND r.rolename = 'Ejecutivo de Ventas 1.".$c_origen."'",[]);

        $sq2 = $adb->pquery("SELECT u.id FROM vtiger_users u
                JOIN vtiger_user2role u2r ON u2r.userid=u.id 
                JOIN vtiger_role r ON r.roleid = u2r.roleid 
                WHERE u.deleted = 0 AND r.rolename = 'Ejecutivo de Ventas 1.".$c_grupo."'",[]);
        
        if(!empty($adb->num_rows($sq1)) && !empty($adb->num_rows($sq2)))
        {
            #Arma de la matriz de asignación de usuarios.
            $_users = [];
            for ($i=0; $i < $adb->num_rows($sq1); $i++) { 
                $_users[$adb->query_result($sq1,$i,'id')] = $adb->query_result($sq2,$i,'id');
            }
            /**
             * $from: usuario inicial
             * $to: usuario objetivo
             */
            foreach ($_users as $from => $to) {
                debug("[INFO]:: VALIDANDO QUE EL USUARIO $to NO TENGA OPORTUNIDADES PARA B2C-0".$c_grupo);
                #Verifica que el usuario $to no tenga oportunidades asignadas en su grupo.
                $qv = $adb->pquery("SELECT p.potentialid FROM vtiger_potentialscf p JOIN vtiger_crmentity c ON c.crmid = p.potentialid AND c.deleted = 0 WHERE p.cf_907 = ? AND c.smownerid = ?",["B2C-0".$c_grupo,$to]);
                
                if($adb->num_rows($qv) == 0)
                {
                    debug("[INFO]:: OBTENIENDO LAS OPORTUNIDADES B2C-0".$c_origen." DEL USUARIO $from");
                    #Obtiene las oportunidades del usuario inicial
                    $sq = $adb->pquery("SELECT p.potentialid FROM vtiger_potentialscf p JOIN vtiger_crmentity c ON c.crmid = p.potentialid AND c.deleted = 0 WHERE p.cf_907 = ? AND c.smownerid = ?",["B2C-0".$c_origen,$from]);
                    if($adb->num_rows($sq) > 0)
                    {
                        debug("[INFO]:: ".$adb->num_rows($sq)." OPORTUNIDADES ENCONTRADAS PARA B2C-0".$c_origen.". USUARIO $from");
                        $c = 0;
                        while($row = $adb->fetch_row($sq))
                        {   ++$c;
                            $pRecordModel = Vtiger_Record_Model::getInstanceById($row['potentialid'],'Potentials'); #Registro
                            $pNRecordModel = clone $pRecordModel; #Nueva instancia
                            $pNRecordModel->set('mode','');
                            $pNRecordModel->set('assigned_user_id',$to);
                            $pNRecordModel->set('gerencia',"Sucursal ".$c_grupo);
                            $pNRecordModel->set('cf_907',"B2C-0".$c_grupo);
                            $pNRecordModel->set('id','');
                            $pNRecordModel->set('potential_no','');
                            $pNRecordModel->set('record_id','');
                            $pNRecordModel->save();
                            $newId = $pNRecordModel->getId();
                            debug("$c.- SE HA GENERADO LA OPORTUNIDAD ".$newId." A PARTIR DE LA OPORTUNIDAD ORIGEN ".$row['potentialid']);
                        }
                    }
                }
                else{
                    debug("[ERROR]:: EL USUARIO $to YA TIENE ".$adb->num_rows($qv)." OPORTUNIDADES ASIGNADAS PARA EL CASO B2C-0".$c_origen);
                }
                
            }
        }
    }
}

main();