<?php
chdir("../../");

require_once 'data/CRMEntity.php';
include_once 'includes/main/WebUI.php';
include_once 'vtlib/Vtiger/Module.php';
require_once 'includes/Loader.php';
require_once 'include/utils/utils.php';

vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');

ini_set('max_execution_time', 0);
set_time_limit(0);

global $current_user, $adb;
$current_user->id = 1;

/**
 * @method Retorna el nombre del rol que debe tener el usuario
 * @param string $tipo : b2c|b2b
 * @param integer $seccion
 * @param integer $grupo
 * 
 * @return string|null
 */
function getRole($tipo, $seccion, $grupo)
{
    global $adb;
    switch ($tipo) {
        case 'b2c': $pref = 'Ejecutivo de ventas ';                break;
        case 'b2b': $pref = 'Ejecutivo de ventas corporativas ';  break;
    }
    $tx = $pref.$seccion.".".$grupo;
    #Busca la existencia del rol en la BD 
    $r = $adb->pquery("SELECT roleid FROM vtiger_role WHERE rolename like '%".$tx."%'",[]);

    return $adb->num_rows($r) == 1 ? decode_html($adb->query_result($r,0,'roleid')) : "";
}

if(isset($_POST['action']))
{
    switch ($_POST['action']) {
        case 'Generar':
            $iteraciones = $_POST['n'];
            if(!empty($iteraciones))
            {
                #Obtiene los usuarios de la sección 1
                $q = $adb->pquery("SELECT u.* FROM vtiger_users u
                JOIN vtiger_user2role u2r ON u2r.userid=u.id 
                JOIN vtiger_role r ON r.roleid = u2r.roleid 
                WHERE u.deleted = 0 AND r.rolename like 'Ejecutivo de Ventas%' AND r.rolename like '%1.%'",[]);
                $usuarios_1 = [];
                
                while ($row = $adb->fetch_row($q)) {
                    $usuarios_1[] = array_map("decode_html",$row);
                }
                #Cada iteracion representa una sección
                $numbers = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9];

                for($i = 2; $i <= $iteraciones+1; $i++)
                {
                    /*------------------ CREA USUARIOS DE LA SECCION 1------------------*/
                    
                    $users_ = []; #Matriz que mapea el usuario orignal y el generado
                    $tipo_ = []; #Matriz que mapea el usuario orignal y el generado
                    $grupo_ = []; #Matriz que mapea el usuario orignal y el generado
                    debug("[INFO::] GENERANDO USUARIO.......");
                    foreach ($usuarios_1 as $user) {
                        $Nusername = str_replace($numbers, "", $user['user_name']).$i; #Genera el nombre de usuario de la seccion
                        #Valida que el usuario no exista
                        $query_v1 = $adb->pquery("SELECT id FROM vtiger_users WHERE user_name = ?",[$Nusername]);
                         
                        if(empty($adb->num_rows($query_v1)))
                        {
                            #Verifica si es B2C o B2B
                            $tipo = strstr($user['gerencia'],'Sucursal') === false ? 'b2b' : 'b2c';
                            #Obtiene el Grupo
                            if($tipo == "b2b") $grupo = str_replace("Corporativa ","",$user['gerencia']);
                            else if($tipo == 'b2c') $grupo = str_replace("Sucursal ","",$user['gerencia']);

                            #Crea el usuario
                            $userCModel     = Users_Record_Model::getInstanceById($user['id'],'Users');
                            $NuserCModel = clone $userCModel;
                            $NuserCModel->set('mode','');
                            $NuserCModel->set('id','');
                            $NuserCModel->set('user_name',$Nusername);
                            $NuserCModel->set('roleid',getRole($tipo,$i,$grupo));
                            $NuserCModel->set('reports_to_id',''); #Se llenará luego
                            $NuserCModel->save();
                            $idUser = $NuserCModel->getId();

                            debug("[INFO]:: El usuario $Nusername has sido creado con ID $idUser.");
                        }
                        else{
                            debug("[INFO]:: El usuario $Nusername ya existe.");
                            $idUser = $adb->query_result($query_v1,0,'id');
                        }

                        $users_[$user['id']] = $idUser;
                        $tipo_[$user['id']] = $tipo;
                        $gerencia_[$users['id']] = $user['gerencia'];
                        $grupo_[$user['id']] = $grupo;
                        $gen_[$idUser] = $Nusername;
                        
                        /**Configura el Informa a - de los usuarios generados: */
                    }

                    /*------------------ FIN ------------------*/

                    /**
                     * ------------------ REPLICA LAS OPORTUNIDADES DE LOS USUARIOS DE LA SECCION 1------------------
                     */
                    debug("[INFO::] GENERANDO OPORTUNIDADES.......");
                    foreach ($users_ as $from => $to) {
                        #Verifica que el usuario $to no tenga oportunidades asignadas en su grupo.
                        #$adb->setDebug(true);
                        $qv = $adb->pquery("SELECT p.potentialid FROM vtiger_potentialscf p JOIN vtiger_crmentity c ON c.crmid = p.potentialid AND c.deleted = 0 WHERE c.smownerid = ?",[$to]);
                        #$adb->setDebug(false);
                        if(empty($adb->num_rows($qv)))
                        {
                            #Obtiene las oportunidades del usuario inicial
                            $sq = $adb->pquery("SELECT p.potentialid FROM vtiger_potentialscf p JOIN vtiger_crmentity c ON c.crmid = p.potentialid AND c.deleted = 0 WHERE c.smownerid = ?",[$from]);
                            if($adb->num_rows($sq) > 0)
                            {
                               # debug("[INFO]:: ".$adb->num_rows($sq)." OPORTUNIDADES ENCONTRADAS PARA EL USUARIO $from");
                                $c = 0;
                                while($row = $adb->fetch_row($sq))
                                {   ++$c;
                                    $pRecordModel = Vtiger_Record_Model::getInstanceById($row['potentialid'],'Potentials'); #Registro
                                    $pNRecordModel = clone $pRecordModel; #Nueva instancia
                                    $pNRecordModel->set('mode','');
                                    $pNRecordModel->set('assigned_user_id',$to);
                                    $pNRecordModel->set('gerencia',$gerencia_[$from]);
                                    $pNRecordModel->set('cf_907',$grupo_[$from]);
                                    $pNRecordModel->set('id','');
                                    $pNRecordModel->set('potential_no','');
                                    $pNRecordModel->set('record_id','');
                                    $pNRecordModel->save();
                                    $newId = $pNRecordModel->getId();
                                    #debug("$c.- SE HA GENERADO LA OPORTUNIDAD ".$newId." A PARTIR DE LA OPORTUNIDAD ORIGEN ".$row['potentialid']);
                                }

                                debug("[INFO]:: SE GENERARON LAS OPORTUNIDADES PARA EL USUARIO ".$gen_[$to]);
                            }
                        }
                        else{
                            debug("[ERROR]:: EL USUARIO ".$gen_[$to]." YA CUENTA CON OPORTUNIDADES ASIGNADAS.");
                        }
                    }

                    /*------------------ FIN ------------------*/
                }
            }
            break;
        
        default:
            # code...
            break;
    }
}